@extends('installer.layout')

@section('content')
    <div class="text-center py-12">
        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-green-100 mb-6">
            <svg class="h-8 w-8 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
        </div>
        
        <h2 class="text-3xl font-bold text-gray-900 mb-4">Installation Complete!</h2>
        <p class="text-gray-600 mb-8">
            Your application has been successfully installed and configured. You can now log in to your dashboard.
        </p>

        <div class="space-y-4">
            <a href="{{ url('/login') }}" class="inline-flex justify-center w-full py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors">
                Go to Dashboard
            </a>
            
            <a href="{{ url('/') }}" class="inline-flex justify-center w-full py-3 px-4 border border-gray-300 rounded-lg shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors">
                View Homepage
            </a>
        </div>
    </div>
@endsection
